var core = {
  "start": function () {
    core.load();
  },
  "install": function () {
    core.load();
  },
  "load": function () {
    core.update.button();
  },
  "update": {
    "button": function () {
      app.button.icon(null, config.addon.state);
      app.button.title(null, "Custom Style Script: " + (config.addon.state === "disabled" ? "OFF" : "ON"));
    }
  },
  "inject": function (e) {
    if (config.addon.state === "enabled") {
      var array = config.code.array;
      /*  */
      for (var i = 0; i < array.length; i++) {
        if (array[i].state === "active") {
          try {
            var frameIds = array[i].checked_i ? (array[i].checked_t ? [e.frameId] : (e.frameId !== 0 ? [e.frameId] : null)) : (array[i].checked_t ? [0] : null);
            if (frameIds) {
              var url = array[i].url;
              var action = url === '*' ? true : (array[i].checked_d ? (new URL(e.top).hostname) === (new URL(url).hostname) : e.top === url);
              if (action) {
                if (array[i].script) { /* script :: code */
                  app.tab.inject.js({
                    "world": "MAIN",
                    "args": [i, array[i].script],
                    "target": {"tabId": e.tabId, "frameIds": frameIds},
                    "func": function (i, code) {
                      var script = document.createElement("script");
                      script.setAttribute("id", "custom-script-code-" + i);
                      script.setAttribute("type", "text/javascript");
                      script.textContent = code;
                      document.documentElement.appendChild(script);
                    }
                  });
                }
                /*  */
                if (array[i].scripturl) { /* script :: link */
                  app.tab.inject.js({
                    "world": "MAIN",
                    "args": [i, array[i].scripturl],
                    "target": {"tabId": e.tabId, "frameIds": frameIds},
                    "func": function (i, url) {
                      var script = document.createElement("script");
                      script.setAttribute("id", "custom-script-link-" + i);
                      script.setAttribute("type", "text/javascript");
                      script.src = url;
                      document.documentElement.appendChild(script);
                    }
                  });
                }
                /*  */
                if (array[i].style) { /* style :: code */
                  app.tab.inject.js({
                    "world": "MAIN",
                    "args": [i, array[i].style],
                    "target": {"tabId": e.tabId, "frameIds": frameIds},
                    "func": function (i, code) {
                      var style = document.createElement("style");
                      style.setAttribute("id", "custom-style-code-" + i);
                      style.setAttribute("type", "text/css");
                      style.textContent = code;
                      document.documentElement.appendChild(style);
                    }
                  });
                }
                /*  */
                if (array[i].styleurl) { /* style :: link */
                  app.tab.inject.js({
                    "world": "MAIN",
                    "args": [i, array[i].styleurl],
                    "target": {"tabId": e.tabId, "frameIds": frameIds},
                    "func": function (i, url) {
                      var link = document.createElement("link");
                      link.setAttribute("id", "custom-style-link-" + i);
                      link.setAttribute("rel", "stylesheet");
                      link.setAttribute("type", "text/css");
                      link.href = url;
                      document.documentElement.appendChild(link);
                    }
                  });
                }
              }
            }
          } catch (e) {}
        }
      }
    }
  }
};

app.options.receive("store", function (e) {
  config.code.array = e.codeArray;
});

app.options.receive("load", function () {
  app.options.send("storage", {
    "codeArray": config.code.array,
  });
});

app.popup.receive("load", function () {
  app.popup.send("storage", {
    "state": config.addon.state
  });
});

app.popup.receive("state", function () {
  config.addon.state = config.addon.state === "disabled" ? "enabled" : "disabled";
  /*  */
  core.update.button();
  app.popup.send("storage", {
    "state": config.addon.state
  });
});

app.page.receive("inject", core.inject);
app.popup.receive("reload", app.tab.reload);
app.popup.receive("options", app.tab.options);
app.popup.receive("support", function () {app.tab.open(app.homepage())});
app.popup.receive("donation", function () {app.tab.open(app.homepage() + "?reason=support")});

app.on.startup(core.start);
app.on.installed(core.install);
