// Content script to inject additional WebSocket monitoring

// Inject the WebSocket monitoring script
const script = document.createElement('script');
script.src = chrome.runtime.getURL('injected.js');
script.onload = function() {
  this.remove();
};
(document.head || document.documentElement).appendChild(script);

// Listen for messages from the injected script
window.addEventListener('message', function(event) {
  // Only accept messages from same origin
  if (event.source !== window) return;
  
  if (event.data.type === 'WEBSOCKET_CREATED') {
    
    // Send message to background script if needed (using callback for Manifest V2)
    chrome.runtime.sendMessage({
      type: 'WEBSOCKET_DETECTED',
      url: event.data.url,
      timestamp: Date.now()
    }, function(response) {
      // Handle response if needed
      if (chrome.runtime.lastError) {
      }
    });
  }
});

// Monitor for WebSocket creation via MutationObserver as backup
const observer = new MutationObserver(function(mutations) {
  mutations.forEach(function(mutation) {
    if (mutation.type === 'childList') {
      mutation.addedNodes.forEach(function(node) {
        if (node.nodeType === Node.ELEMENT_NODE) {
          // Check for any script tags that might create WebSockets
          if (node.tagName === 'SCRIPT' && node.textContent && 
              (node.textContent.includes('WebSocket') || node.textContent.includes('api.vyond.com'))) {
          }
        }
      });
    }
  });
});

// Start observing
observer.observe(document, {
  childList: true,
  subtree: true
});

// Clean up observer when page unloads
window.addEventListener('beforeunload', function() {
  observer.disconnect();
});
