// Injected script to monitor WebSocket creation at the page level
(function () {
  "use strict";

  console.log("WebSocket Header Modifier: Injected script loaded");

  // Store original WebSocket constructor
  const OriginalWebSocket = window.WebSocket;

  // Override WebSocket constructor
  window.WebSocket = function (url, protocols) {
    console.log(
      "WebSocket Header Modifier (Injected): WebSocket constructor called with URL:",
      url
    );

    // Check if this is a Vyond API WebSocket
    if (
      url.includes("api.vyond.com/socketserver/connection") ||
      url.includes("wss://api.vyond.com/socketserver/connection")
    ) {
      console.log(
        "WebSocket Header Modifier (Injected): Vyond WebSocket detected!"
      );

      // Notify content script
      window.postMessage(
        {
          type: "WEBSOCKET_CREATED",
          url: url,
          timestamp: Date.now(),
        },
        "*"
      );
    }

    // Create the actual WebSocket instance
    const ws = new OriginalWebSocket(url, protocols);

    // Add event listeners to monitor WebSocket state
    ws.addEventListener("open", function (event) {
      console.log(
        "WebSocket Header Modifier (Injected): WebSocket opened:",
        url
      );
    });

    ws.addEventListener("error", function (event) {
      console.error(
        "WebSocket Header Modifier (Injected): WebSocket error:",
        url,
        event
      );
    });

    ws.addEventListener("close", function (event) {
      console.log(
        "WebSocket Header Modifier (Injected): WebSocket closed:",
        url,
        "Code:",
        event.code,
        "Reason:",
        event.reason
      );
    });

    return ws;
  };

  // Preserve original WebSocket properties and methods
  Object.setPrototypeOf(window.WebSocket, OriginalWebSocket);
  Object.defineProperty(window.WebSocket, "prototype", {
    value: OriginalWebSocket.prototype,
    writable: false,
  });

  // Copy static properties with proper descriptor handling
  for (const prop in OriginalWebSocket) {
    if (OriginalWebSocket.hasOwnProperty(prop)) {
      try {
        const descriptor = Object.getOwnPropertyDescriptor(
          OriginalWebSocket,
          prop
        );
        if (descriptor && descriptor.configurable !== false) {
          Object.defineProperty(window.WebSocket, prop, descriptor);
        } else if (descriptor && descriptor.writable !== false) {
          window.WebSocket[prop] = OriginalWebSocket[prop];
        }
      } catch (e) {
        // Silently ignore properties that cannot be copied
        console.debug(
          "WebSocket Header Modifier: Could not copy property",
          prop,
          e
        );
      }
    }
  }

  // Ensure WebSocket constants are available
  if (typeof window.WebSocket.CONNECTING === "undefined") {
    try {
      Object.defineProperty(window.WebSocket, "CONNECTING", {
        value: 0,
        enumerable: true,
      });
      Object.defineProperty(window.WebSocket, "OPEN", {
        value: 1,
        enumerable: true,
      });
      Object.defineProperty(window.WebSocket, "CLOSING", {
        value: 2,
        enumerable: true,
      });
      Object.defineProperty(window.WebSocket, "CLOSED", {
        value: 3,
        enumerable: true,
      });
    } catch (e) {
      console.debug(
        "WebSocket Header Modifier: Could not define WebSocket constants",
        e
      );
    }
  }

  // Also monitor fetch requests for WebSocket upgrades
  const originalFetch = window.fetch;
  window.fetch = function (...args) {
    const url = args[0];
    const options = args[1] || {};

    // Check for WebSocket upgrade requests
    if (
      typeof url === "string" &&
      url.includes("api.vyond.com") &&
      options.headers &&
      options.headers["Upgrade"] === "websocket"
    ) {
      console.log(
        "WebSocket Header Modifier (Injected): WebSocket upgrade request detected via fetch:",
        url
      );

      window.postMessage(
        {
          type: "WEBSOCKET_CREATED",
          url: url,
          timestamp: Date.now(),
        },
        "*"
      );
    }

    return originalFetch.apply(this, args);
  };

  console.log(
    "WebSocket Header Modifier (Injected): WebSocket monitoring setup complete"
  );
})();
