var background = (function () {
  var tmp = {};
  chrome.runtime.onMessage.addListener(function (request) {
    for (var id in tmp) {
      if (tmp[id] && (typeof tmp[id] === "function")) {
        if (request.path === "background-to-options") {
          if (request.method === id) tmp[id](request.data);
        }
      }
    }
  });
  /*  */
  return {
    "receive": function (id, callback) {tmp[id] = callback},
    "send": function (id, data) {chrome.runtime.sendMessage({"path": "options-to-background", "method": id, "data": data})}
  }
})();

var config = {
  "code": {"array": []},
  "store": {
    "data": function (render) {
      background.send("store", {"codeArray": config.code.array});
      if (render) config.table.fill({"codeArray": config.code.array});
    }
  },
  "load": function () {
    var explore = document.getElementById("explore");
    var add = document.getElementById("input-field-add");
    var table = document.getElementById("code-array-table");
    /*  */
    add.addEventListener("click", config.table.add.item);
    table.addEventListener("click", config.storage.button);
    explore.style.display = navigator.userAgent.indexOf("Edg") !== -1 ? "none": "block";
    /*  */
    background.send("load");
    window.removeEventListener("load", config.load, false);
  },
  "storage": {
    "textarea": function (e) {
      var tr = e.target.closest("tr");
      if (tr) {
        var index = parseInt(tr.getAttribute("clickeditem"));
        if (index !== undefined) {
          var type = e.target.getAttribute("type");
          if (type) {
            config.code.array[index][type] = e.target.value;
            config.store.data(false);
          }
        }
      }
    },
    "button": function (e) {
      var tr = e.target.closest("tr");
      if (tr) {
        var index = parseInt(tr.getAttribute("clickeditem"));
        if (index !== undefined) {
          if (e.target.getAttribute("type") === "toggle") {
            config.code.array[index].state = tr.getAttribute("state") === "active" ? "inactive" : "active";
            config.store.data(true);
          }
          /*  */
          if (e.target.getAttribute("type") === "close") {
            var action = window.confirm("Are you sure you want to remove this item?");
            if (action) {
              config.code.array.splice(index, 1);
              config.store.data(true);
            }
          }
          /*  */
          if (e.target.getAttribute("type") === "checkbox") {
            if (e.target.getAttribute("rule") === "top") config.code.array[index].checked_t = e.target.checked;
            if (e.target.getAttribute("rule") === "domain") config.code.array[index].checked_d = e.target.checked;
            if (e.target.getAttribute("rule") === "iframe") config.code.array[index].checked_i = e.target.checked;
            /*  */
            config.store.data(false);
          }
        }
      }
    }
  },
  "table": {
    "add": {
      "item": function () {
        var inputarea = document.getElementById("input-field");
        /*  */
        var url = inputarea.children[0].children[0];
        var script = inputarea.children[1].children[0];
        var style = inputarea.children[2].children[0];
        var obj = {
          "url": '',
          "style": '',
          "script": '',
          "styleurl": '',
          "scripturl": '',
          "state": 'active',
          "checked_d": true,
          "checked_t": true,
          "checked_i": false
        };
        /*  */
        try {
          obj.url = (url.value === '*') ? '*' : new URL(url.value).href;
        } catch (e) {
          obj.url = "about:blank";
        }
        /*  */
        url.value = obj.url;
        obj.style = style.value;
        obj.script = script.value;
        config.code.array = config.code.array.filter(function (e) {
          return e.url !== obj.url || e.script !== obj.script || e.style !== obj.style;
        });
        /*  */
        config.code.array.push(obj);
        config.store.data(true);
      }
    },
    "fill": function (e) {
      var tbody = document.getElementById("code-array-tbody");
      tbody.textContent = '';
      /*  */
      var count = 1;
      config.code.array = e.codeArray ? e.codeArray : [];
      if (config.code.array && config.code.array.length) {
        for (var i = 0; i < config.code.array.length; i++) {
          var url = document.createElement("td");
          var top = document.createElement("td");
          var close = document.createElement("td");
          var domain = document.createElement("td");
          var iframe = document.createElement("td");
          var toggle = document.createElement("td");
          var linetd = document.createElement("td");
          var styleurl = document.createElement("td");
          var stylecode = document.createElement("td");
          var scripturl = document.createElement("td");
          var scriptcode = document.createElement("td");
          /*  */
          var trtop = document.createElement("tr");
          var trmiddle = document.createElement("tr");
          var trbottom = document.createElement("tr");
          var trseperator = document.createElement("tr");
          /*  */
          var input_d = document.createElement("input");
          var input_t = document.createElement("input");
          var input_i = document.createElement("input");
          /*  */
          url.setAttribute("type", "url");
          top.setAttribute("type", "check");
          close.setAttribute("type", "close");
          domain.setAttribute("type", "check");
          iframe.setAttribute("type", "check");
          styleurl.setAttribute("type", "url");
          toggle.setAttribute("type", "toggle");
          scripturl.setAttribute("type", "url");
          stylecode.setAttribute("type", "style");
          scriptcode.setAttribute("type", "script");
          /*  */
          var textarea = document.createElement("textarea");
          textarea.addEventListener("change", config.storage.textarea);
          textarea.setAttribute("placeholder", "Add URL (i.e. https://www.google.com/)");
          textarea.value = config.code.array[i].url || "about:blank";
          textarea.setAttribute("type", "url");
          url.appendChild(textarea);
          /*  */
          var textarea = document.createElement("textarea");
          textarea.value = config.code.array[i].scripturl || '';
          textarea.addEventListener("change", config.storage.textarea);
          textarea.setAttribute("placeholder", "JavaScript link (i.e. https://code.jquery.com/...)");
          textarea.setAttribute("type", "scripturl");
          scripturl.appendChild(textarea);
          /*  */
          var textarea = document.createElement("textarea");
          textarea.value = config.code.array[i].styleurl || '';
          textarea.addEventListener("change", config.storage.textarea);
          textarea.setAttribute("placeholder", "CSS link (i.e. https://www.bootstrapcdn.com/...)");
          textarea.setAttribute("type", "styleurl");
          styleurl.appendChild(textarea);
          /*  */
          var textarea = document.createElement("textarea");
          textarea.addEventListener("change", config.storage.textarea);
          textarea.setAttribute("placeholder", "Add CSS code.");
          textarea.value = config.code.array[i].style || '';
          textarea.setAttribute("class", "expand");
          textarea.setAttribute("type", "style");
          stylecode.appendChild(textarea);
          /*  */
          var textarea = document.createElement("textarea");
          textarea.addEventListener("change", config.storage.textarea);
          textarea.setAttribute("placeholder", "Add JS code.");
          textarea.value = config.code.array[i].script || '';
          textarea.setAttribute("class", "expand");
          textarea.setAttribute("type", "script");
          scriptcode.appendChild(textarea);
          /*  */
          input_t.setAttribute("rule", "top");
          input_t.setAttribute("type", "checkbox");
          input_t.checked = config.code.array[i].checked_t;
          top.appendChild(input_t);
          /*  */
          input_d.setAttribute("rule", "domain");
          input_d.setAttribute("type", "checkbox");
          input_d.checked = config.code.array[i].checked_d;
          domain.appendChild(input_d);
          /*  */
          input_i.setAttribute("rule", "iframe");
          input_i.setAttribute("type", "checkbox");
          input_i.checked = config.code.array[i].checked_i;
          iframe.appendChild(input_i);
          /*  */
          close.textContent = '⛌';
          trtop.setAttribute("clickeditem", i);
          linetd.textContent = "Item #" + count;
          trmiddle.setAttribute("clickeditem", i);
          trbottom.setAttribute("clickeditem", i);
          trseperator.setAttribute("class", "line");
          trseperator.setAttribute("clickeditem", i);
          trtop.setAttribute("state", config.code.array[i].state);
          toggle.setAttribute("state", config.code.array[i].state);
          trmiddle.setAttribute("state", config.code.array[i].state);
          trbottom.setAttribute("state", config.code.array[i].state);
          trseperator.setAttribute("state", config.code.array[i].state);
          toggle.textContent = config.code.array[i].state === "active" ? '✔' : '⊖';
          /*  */
          linetd.setAttribute("colspan", '8');
          styleurl.setAttribute("type", "link");
          stylecode.setAttribute("colspan", '8');
          scripturl.setAttribute("type", "link");
          scriptcode.setAttribute("colspan", '8');
          /*  */
          trtop.appendChild(url);
          trtop.appendChild(scripturl);
          trtop.appendChild(styleurl);
          trtop.appendChild(domain);
          trtop.appendChild(top);
          trtop.appendChild(iframe);
          trtop.appendChild(toggle);
          trtop.appendChild(close);
          trmiddle.appendChild(scriptcode);
          trbottom.appendChild(stylecode);
          trseperator.appendChild(linetd);
          /*  */
          tbody.appendChild(trseperator);
          tbody.appendChild(trtop);
          tbody.appendChild(trmiddle);
          tbody.appendChild(trbottom);
          /*  */
          count++;
        }
      }
    }
  }
};

background.receive("storage", config.table.fill);
window.addEventListener("load", config.load, false);
