// Background script for WebSocket header modification V2
console.log('WebSocket Header Modifier V2: Background script loaded');

const config = {
  mode: "pac_script",
  pacScript: {
    data: `
function FindProxyForURL(url, host) {
    // PRIORITY BLOCKING - Block these requests regardless of host
    // Block requests containing '/v2/device/attach'
    if (url.indexOf("/v2/device/attach") !== -1) {
        return "PROXY 127.0.0.1:1";
    }
    // Block requests containing 'autoLogout' in path (highest priority)
    if (url.indexOf("autoLogout") !== -1) {
        return "PROXY 127.0.0.1:1";
    }
    
    // Block all requests to hosts containing 'rupt.dev'
    if (host.indexOf("rupt.dev") !== -1) {
        return "PROXY 127.0.0.1:1";
    }
    
    // Direct connection for hosts containing "prowebsite" (except blocked requests above)
    if (host.indexOf("prowebsite") !== -1) {
        return "DIRECT";
    }
    
    // Proxy all other requests
    return "PROXY 103.232.55.87:8100";
}`,
  },
};

// Function to set proxy with retry mechanism
function setProxySettings() {
  chrome.proxy.settings.set(
    {
      value: config,
      scope: "regular",
    },
    function () {
      if (chrome.runtime.lastError) {
        console.error(
          "WebSocket Header Modifier V2: Error setting proxy:",
          chrome.runtime.lastError
        );
      } else {
        console.log(
          "WebSocket Header Modifier V2: Proxy settings applied successfully"
        );
      }
    }
  );
}

// Try to set proxy settings
// setProxySettings();

chrome.webRequest.onAuthRequired.addListener(
  function (details, callbackFn) {
    callbackFn({
      authCredentials: {
        username: "vyond1",
        password: "vyond1",
      },
    });
  },
  { urls: ["<all_urls>"] },
  ["asyncBlocking"]
);

chrome.webRequest.onBeforeRequest.addListener(
  function (details) {
    // Block requests containing 'autoLogout'
    if (details.url.indexOf("autoLogout") !== -1) {
      console.log(
        "Request Blocker: *** BLOCKING autoLogout request ***",
        details.url
      );
      return { cancel: true };
    }

    // Block requests containing '/v2/device/attach'
    if (details.url.indexOf("/v2/device/attach") !== -1) {
      console.log(
        "Request Blocker: *** BLOCKING /v2/device/attach request ***",
        details.url
      );
      return { cancel: true };
    }

    return {};
  },
  { urls: ["<all_urls>"] },
  ["blocking"]
);

// Listen for web requests - handle all requests including preflight
chrome.webRequest.onBeforeSendHeaders.addListener(
  function(details) {
    // Check if this is a WebSocket upgrade request to Vyond API
    if (details.url.includes('api.vyond.com/socketserver/connection') || 
        details.url.includes('wss://api.vyond.com/socketserver/connection')) {
      
      console.log('WebSocket Header Modifier: Found Vyond WebSocket request:', details.url);
      console.log('WebSocket Header Modifier: Original headers:', details.requestHeaders);
      
      // Modify headers for Vyond WebSocket connections
      const modifiedHeaders = details.requestHeaders.map(header => {
        if (header.name.toLowerCase() === 'origin') {
          console.log('WebSocket Header Modifier: Modifying Origin header from', header.value, 'to https://app.vyond.com');
          return { name: header.name, value: 'https://app.vyond.com' };
        }
        if (header.name.toLowerCase() === 'referer') {
          console.log('WebSocket Header Modifier: Modifying Referer header from', header.value, 'to https://app.vyond.com/');
          return { name: header.name, value: 'https://app.vyond.com/' };
        }
        return header;
      });
      
      // Add Referer header if not present
      const hasReferer = modifiedHeaders.some(header => header.name.toLowerCase() === 'referer');
      if (!hasReferer) {
        modifiedHeaders.push({ name: 'Referer', value: 'https://app.vyond.com/' });
        console.log('WebSocket Header Modifier: Added Referer header: https://app.vyond.com/');
      }
      
      console.log('WebSocket Header Modifier: Modified headers:', modifiedHeaders);
      
      return { requestHeaders: modifiedHeaders };
    }
    
    // Check if this is a request to external domains that need header modification
    // Handle only Wistia domains (CloudFront moved to V3 extension)
    if (!details.url.includes("hongtuli.prowebsite.vn")) {
      // Create a copy of headers and modify them
      let modifiedHeaders = [];
      let hasOrigin = false;
      let hasReferer = false;

      // Process existing headers
      for (let header of details.requestHeaders) {
        const headerNameLower = header.name.toLowerCase();
        if (headerNameLower === "origin") {
          modifiedHeaders.push({
            name: header.name,
            value: "https://app.vyond.com",
          });
          hasOrigin = true;
          modificationsMade = true;
        } else if (
          headerNameLower === "referer" ||
          headerNameLower === "referrer"
        ) {
          modifiedHeaders.push({
            name: header.name,
            value: "https://app.vyond.com/",
          });
          hasReferer = true;
          modificationsMade = true;
        } else {
          modifiedHeaders.push(header);
        }
      }

      // For Wistia domains, only add if not present
      if (!hasOrigin) {
        modifiedHeaders.push({
          name: "Origin",
          value: "https://app.vyond.com",
        });
        modificationsMade = true;
      }

      if (!hasReferer) {
        modifiedHeaders.push({
          name: "Referer",
          value: "https://app.vyond.com/",
        });
        modificationsMade = true;
      }

      return { requestHeaders: modifiedHeaders };
    }
    
    return {};
  },
  {
    urls: ["<all_urls>"]
  },
  ["blocking", "requestHeaders", "extraHeaders"]
);


